package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.core.WebChatMedia;
import com.avaya.ccs.javafxrefclient.Logger;

public class WebChatMessageRequest extends InteractionRequest{
	  private static final Logger LOG = Logger.getLogger(WebChatMessageRequest.class);
	  
//	  {"Message":"hi this is teh agent","IsWhisper":false}
	  	
	  	String interactionId;
	  	String message;
	  	boolean isWhisper;

	  	public WebChatMessageRequest(String interactionID, String message, boolean isWhisper) {
	        super(LOG, interactionID);
	        LOG.info("WebChatMessageRequest", "interactionId: "+interactionID);
	        this.interactionId=interactionID;
	        this.message=message;
	        this.isWhisper=isWhisper;
	    }

	    /**
	     * The call method executes on the outgoingRequest thread
	     *
	     * @return
	     * @throws Exception
	     */
	    @Override
	    protected Object call() throws Exception {
	        String methodName = "call() ";
	        LOG.info(methodName + "+");	        
	        ((WebChatMedia)getInteraction().getMedia()).sendMessage(message, isWhisper);
	        LOG.info(methodName + "-"); 
	        return null;
	    }
	    	    
}
